
# -*- coding: utf-8 -*-

import suds
import base64
import time
import zipfile

API_URL = "http://vigruzki.rkn.gov.ru/services/OperatorRequest/?wsdl"
XML_FILE_NAME = "C:\\python\\zapros_reestr.xml"
SIG_FILE_NAME = "C:\\python\\zapros_reestr.xml.sig"

def getLastDumpDate(): ##Проверка последнего изменения файла на серве
    client = suds.client.Client(API_URL)
    result=client.service.getLastDumpDate()
    return result

def sendRequest(requestFile,signatureFile): # Формируем и отправляем запрос на файл, в ответе код 
    file = open(requestFile, "rb")          # входные параметры фаил xml и подпись файла
    data = file.read()
    file.close()
    xml = base64.b64encode(data)
  

    
    file = open(signatureFile, "rb")
    data = file.read()
    file.close()
    print data
    sign = base64.b64encode(data)
 
    client = suds.client.Client(API_URL)
    result=client.service.sendRequest(xml,sign,'2.0')

    return dict(((k, v.encode('utf-8')) if isinstance(v, suds.sax.text.Text) else (k, v)) for (k, v) in result)

def getResult(code): # скачиваем фаил 
    client = suds.client.Client(API_URL)
    result=client.service.getResult(code)
    return dict(((k, v.encode('utf-8')) if isinstance(v, suds.sax.text.Text) else (k, v)) for (k, v) in result)



date_file=getLastDumpDate()

request=sendRequest(XML_FILE_NAME,SIG_FILE_NAME)
    #Проверяем, принят ли запрос к обработке

if request['result']:
    #Запрос не принят, получен код
    code=request['code']
    print 'Got code %s' % (code)
    print 'LastDumpDate %s' % (date_file)
    print 'Trying to get result...'
    print 'sleep 60 sec'
    time.sleep(60)
    while 1:
    #Пытаемся получить архив по коду
        request=getResult(code)
        if request['result']:
            #Архив получен, скачиваем его и распаковываем
            print 'Got it!'
            file = open('Z:\\dump.zip', "wb")
            #file = open('C:\\python\\result'+str(date_file)+'.zip', "wb")
            file.write(base64.b64decode(request['registerZipArchive']))
            file.close()
            break
        else:
            #Архив не получен, проверяем причину.
            if request['resultComment']=='запрос обрабатывается':
                #Если это сообщение об обработке запроса, то просто ждем минутку.
                print 'Not ready yet.'
                print('sleep 60 sec')
                time.sleep(60)
            else:
                #Если это любая другая ошибка, выводим ее и прекращаем работу
                print 'Error: %s' % request['resultComment']
                break
else:
      #Запрос не принят, возвращаем ошибку
    print 'Error: %s' % request['resultComment']


