﻿
#snakeFlow ver 1.0 http://snakeproject.ru/
#коллектор протокола netflow ver. 5
#для работы с сокетами - модуль socket
#функции для преобразования между Python и Cи структурами - struct
#для работы с датой и временем - datetime
import socket, struct, datetime, re

#Читаем конфигурационный файл(путь выставить к папке с файлом)
file = open('C:/python/configure.txt', 'r')
strings = ''.join(file.readlines())
file.close()

#Параметр вывода данных
pattern = re.compile('write:terminal|write:file|write:mysql')
conf = re.findall(pattern, strings)[0]

c_ip = re.findall(re.compile('ip=[^,]+'), strings)[0].replace('ip=','')
c_port = re.findall(re.compile('port=[^,]+'), strings)[0].replace('port=','')

#Если пишем в базу данных
if conf == "write:mysql": 
    import MySQLdb
    
    c_host = re.findall(re.compile('host=[^ ]+'), strings)[0].replace('host=','')
    c_user = re.findall(re.compile('user=[^ ]+'), strings)[0].replace('user=','')
    c_passwd = re.findall(re.compile('passwd=[^ ]+'), strings)[0].replace('passwd=','')
    c_db = re.findall(re.compile('db=[^ ]+'), strings)[0].replace('db=','')
    
    con = MySQLdb.connect(host=c_host, user=c_user, passwd=c_passwd, db=c_db)
    cur = con.cursor()
    cur.execute('SET NAMES `utf8`')
    
#Функция вывода\вставки данных
def Action(x):
    if x == "write:terminal":
        print "%s:%s -> %s:%s packets:%s bytes:%s time:%s" % (nfdata['saddr'],nfdata['sport'],nfdata['daddr'],nfdata['dport'],nfdata['pcount'],nfdata['bcount'],epoch)
    elif x == "write:file":
        log_file = open('C:/python/log.txt', 'a')
        log_file.write("%s:%s -> %s:%s packets:%s bytes:%s time:%s \r\n" % (nfdata['saddr'],nfdata['sport'],nfdata['daddr'],nfdata['dport'],nfdata['pcount'],nfdata['bcount'],epoch))
        log_file.close()
    elif x == "write:mysql":
        cur.execute("INSERT INTO flow_table(src_ip,src_port,dst_ip,dst_port,packets,bytes,stamp) VALUES ('"+str(nfdata['saddr'])+"',"+str(nfdata['sport'])+",'"+str(nfdata['daddr'])+"',"+str(nfdata['dport'])+","+str(nfdata['pcount'])+","+str(nfdata['bcount'])+",'"+str(epoch)+"')")
        con.commit()
        

#размер заголовка и записи
#Значения взяты  из http://www.cisco.com/c/en/us/td/docs/net_mgmt/netflow_collection_engine/3-6/user/guide/format.html#wp1006108
HEADER = 24
RECORD = 48

#Создаем сокет UDP и запускаем прослушиватель
#параметр socket_family может быть AF_INET или AF_UNIX (WINDOWS или UNIX)
sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
sock.bind((str(c_ip), int(c_port)))

datagram, addr = sock.recvfrom(1500)
   
while True:
    #Принимаем данные с маршрутизатора
	datagram, addr = sock.recvfrom(1500)
    
    #struct.unpack - распаковывает строку, содержащую упакованные данные структуры Си в соответствие с данными форматов 
    #возвращает кортеж, даже если строка содержит один элемент
    #строка должна содержать количество информации указнное форматом
    #распаковка двоичных данных
	(ver, count) = struct.unpack('!HH',datagram[0:4])
    
	if ver != 5: break
    
    #преобразование 32-битного целого числа из сети в машинную последовательность байт
    #время на маршрутизаторе в формате epoch/Unix timestamp конвертируем в формате %Y-%m-%d %H:%M:%S
	epoch = datetime.datetime.fromtimestamp(int(socket.ntohl(struct.unpack('I',datagram[8:12])[0]))).strftime('%Y-%m-%d %H:%M:%S')
    
    #Перебор данных
	for i in range(0, count):
		try:
			base = HEADER+(i*RECORD)

			data = struct.unpack('!IIIIHH',datagram[base+16:base+36])

			nfdata = {}
            #socket.inet_ntoa - преобразование IP адреса в 32-разрядном двоичном формате в формат строки
			nfdata['saddr'] = socket.inet_ntoa(datagram[base+0:base+4])
			nfdata['daddr'] = socket.inet_ntoa(datagram[base+4:base+8])
			nfdata['pcount'] = data[0]
			nfdata['bcount'] = data[1]
			nfdata['sport'] = data[4]
			nfdata['dport'] = data[5]
		except:
			continue
    
        Action(conf) 

con.close()